/*******************************************************
Filename		:  geo_tables.sql
Release 		:  c2.0
SIR			:  1363, 1476
Description		:  Create sequences for Geoposition tables.
                     	   Create Geoposition dimension tables.
                     	   Populate Geoposition tables with data.
Author			:  Ganesh Thadkamalla
Date			:  10/1/2002.
          	           11/25/02 - Dropped lu_geo_country table and its associations. G.Thadkamalla.
                	   06/10/2003 - Consolidated scripts into one. SIR 1476. -C Tsang
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/

/*******************************************************
Create sequences for Geoposition tables.
**********************************************************/

set echo on
spool geo_tables.log
drop sequence seq_geo_county;
drop sequence seq_geo_state;
drop sequence seq_geo_country;

create sequence seq_geo_county
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_geo_state
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_geo_country
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*******************************************************
Create Geoposition dimension tables.
**********************************************************/

drop table di_geo_state;
drop table di_geo_county;

--state

create table di_geo_state
(pk_isn number(12,0),
 fips_state_code char(2) not null,
 state_postal_code char(2),
 state_name varchar2(21),
 country_code char(2),
 country_name char(13));

alter table di_geo_state
add constraint pk_geo_state primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;


create index geo_state02 on di_geo_state(fips_state_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

create index geo_state03 on di_geo_state(state_postal_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

create index geo_state04 on di_geo_state(country_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

-- county
create table di_geo_county
(pk_isn number(12,0),
 fk_geo_state number(12,0),
 fips_county_code char(3),
 county_name varchar2(25));

alter table di_geo_county
add constraint pk_geo_county primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;

alter table di_geo_county
add constraint fk_geo_county01 foreign key (fk_geo_state) references di_geo_state(pk_isn);

create index db_county01 on di_geo_county(fk_geo_state)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

create index db_county02 on di_geo_county(fips_county_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

/*******************************************************
Populate Geoposition tables with data.
**********************************************************/
--state
delete from  di_geo_state;
commit;
set serveroutput on
declare
cursor c1 is
select distinct pa.state_name,pa.state_fips_code,pa.state_postal_code,
pa.country_name,pa.country_code
from storet.tsmgeopa pa;

begin
for c1_var in c1 loop

insert into di_geo_state
(PK_ISN,
 FIPS_state_CODE,
 state_POSTAL_CODE,
 state_NAME,
 country_CODE,
 country_NAME)
values( seq_geo_state.nextval,
        c1_var.state_FIPS_CODE,
        c1_var.state_POSTAL_CODE,
        c1_var.state_NAME,
        c1_var.country_CODE,
	  c1_var.country_NAME);

end loop;
commit;
end;
/

--county
delete from   di_geo_county;
commit;
set serveroutput on;
declare
cursor c1 is 
SELECT pa.fips_county_code,pa.county_name,ls.pk_isn fk_geo_state
FROM storet.tsmgeopa  pa,
        di_geo_state ls
WHERE pa.country_code = 'US'
AND pa.country_code  = ls.country_code
AND pa.state_fips_code  = ls.fips_state_code
order by ls.pk_isn,pa.county_name,pa.fips_county_code;

begin

for c1_var in c1 loop

insert into di_geo_county(PK_ISN,FK_GEO_STATE,FIPS_county_CODE,county_NAME)
values (seq_geo_county.nextval,c1_var.FK_GEO_STATE,c1_var.FIPS_county_CODE,c1_var.county_NAME);

end loop;
commit;
end;
/

/*******************************************************
Establish FK in fa_station tables for Geoposition tables.
**********************************************************/
SET TIME ON

alter table fa_station
add (fk_geo_state number(12,0),
     fk_geo_county number(12,0));

DROP INDEX isd_geo1;
DROP INDEX isd_geo2;


update fa_station sd
set sd.fk_geo_state = (select s.pk_isn from di_geo_state s
                   where s.fips_state_code = sd.fips_state_CODE
                     and s.country_code = sd.country_code)
where sd.country_code is not null
and  sd.fips_state_CODE is not null;

commit;

update fa_station sd
set sd.fk_geo_county = (select c1.pk_isn 
                   from di_geo_county c1, di_geo_state s
                   where c1.fips_county_code = sd.fips_county_CODE
                     and s.fips_state_code = sd.fips_state_CODE
                     and s.country_code = sd.country_code
                      and c1.fk_geo_state = s.pk_isn)
where sd.country_code is not null
and  sd.fips_state_CODE is not null
and  sd.fips_county_code is not null
and sd.country_code ='US';

commit;

create index isd_geo1 on fa_station(fk_geo_state)
tablespace STORETINDX
storage(initial 500k next 500k)
nologging;
commit;

create index isd_geo2 on fa_station(fk_geo_county)
tablespace STORETINDX
storage(initial 500k next 500k)
nologging;
commit;

alter table fa_station 
add constraint fk_sd_geo_state foreign key (fk_geo_state) references di_geo_state(pk_isn);
commit;

alter table fa_station 
add constraint fk_sd_geo_county foreign key (fk_geo_county) references di_geo_county(pk_isn);
commit;

SET TIME off
spool off;
